set more off
pause off
clear
set level 90
macro drop _all
graph set window fontface "Times New Roman"
cd ""
global mainpath "/Users/ekurt/Desktop/MP ASYM/Stata"

use "${mainpath}/Data/Quarter_LP_Ready3_REGS.dta",clear

cap drop sic3
gen sic3 = int(sic/1000)

rename GK_New2019 Extracted_MPShockE 

replace Extracted_MPShockE = 0 if Extracted_MPShockE ==.

label var Extracted_MPShockE "MP Shock (GK extended)"
 
sort gvkeyn cyear cquarter
xtset gvkeyn qdate

capture macro drop nq
global nq = 1

capture drop shock_var*
capture drop group_var*

local shock Extracted_MPShockE 

cap drop posit* negat*

local thresholdp = 2 
local thresholdn = -2 

gen positives_l = Extracted_MPShockE if gs1d > `thresholdp' & gs1d !=.
gen positives_s = Extracted_MPShockE if inrange(gs1d,0,`thresholdp')  & gs1d !=.

gen negatives_l = Extracted_MPShockE if gs1d < `thresholdn' & gs1d !=.
gen negatives_s = Extracted_MPShockE if inrange(gs1d,`thresholdn', 0) & gs1d !=.

replace positives_l = 0 if positives_l ==.
replace negatives_l = 0 if negatives_l ==.

replace positives_s = 0 if positives_s ==.
replace negatives_s = 0 if negatives_s ==.


gen gs1dp_l = .
replace gs1dp_l = gs1d if gs1d > `thresholdp' & gs1d !=.
replace gs1dp_l = 0 if gs1dp_l == .


gen gs1dp_s = .
replace gs1dp_s = gs1d if inrange(gs1d,0,`thresholdp')  & gs1d !=.
replace gs1dp_s = 0 if gs1dp_s == .


gen gs1dn_l = .
replace gs1dn_l = gs1d if gs1d < `thresholdn' & gs1d !=.
replace gs1dn_l = 0 if gs1dn_l == .

gen gs1dn_s = .
replace gs1dn_s = gs1d if inrange(gs1d,`thresholdn', 0) & gs1d !=.
replace gs1dn_s = 0 if gs1dn_s == .


by gvkeyn: gen int_share = xintq*100 / TotalDebt[_n-1]

gen logDebtIssuance = log(DebtIssuance)*100

gen logTotDebt = log(TotalDebt)*100

gen logRealAsset = log(atq/(gva_pindex/100))*100

gen logTotEmp = log(TotEmp)*100

rename TotalDebtGrowth DebtGrowth

* ================================================================

**** RESPONSE VARIABLE, POLICY VARIABLE AND INSTRUMENT INTERACTIONS.

* ================================================================

capture macro drop response
global response  lnempC // lnRealSales // invratio //  

cap drop dlogrealcapx
sort gvkeyn qdate 
by gvkeyn: gen d$response = $response - L.$response

capture macro drop policy_variable
global policy_variable gs1d  

capture macro drop instrument
global instrument Extracted_MPShockE

capture macro drop ppolicy_variable_l
global ppolicy_variable_l gs1dp_l 

capture macro drop ppolicy_variable_s
global ppolicy_variable_s gs1dp_s  


capture macro drop npolicy_variable_l
global npolicy_variable_l gs1dn_l 

capture macro drop npolicy_variable_s
global npolicy_variable_s gs1dn_s 


capture macro drop ninstrument_l
global ninstrument_l negatives_l 

capture macro drop ninstrument_s
global ninstrument_s negatives_s 


capture macro drop pinstrument_l
global pinstrument_l positives_l

capture macro drop pinstrument_s
global pinstrument_s positives_s


drop if DebtAssetRatio < 0
drop if LiquidityRatio < 0
drop if saleq < 0
drop if invratio < 0

drop if cyear < 1980
drop if cyear == 1980 & cquarter ==1
drop if cyear == 1980 & cquarter ==2

drop if cyear >= 2020

label var lnRealSales "Percent"
label var lnempC "Percent"
label var invratio "Percentage Points"


do "${mainpath}/Do/ROBUSTNESS/52A.LP_SmallLarge shocks.do" 
